import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns 
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv")   

# Plot scatter plots  
fig, axes = plt.subplots(2, 2, figsize=(12, 8))  
  
sns.scatterplot(data=credit_customers_numerical, x='credit_history', y='class_binary', ax=axes[0, 0])   
axes[0, 0].set_title('Loan Approval Rates vs. Credit History')  

plt.tight_layout()  
plt.savefig('ref_result/scatterplot_1.png')
plt.show() 

  